/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.basic_attack;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.forixaim.battle_arts.core_assets.animations.AnimationHelpers;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.styles.ImperatriceLumiereStyles;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class ImperatriceAttacks
extends BasicAttack {
    private static final UUID EVENT_UUID = UUID.fromString("bb4af80f-603a-4b52-a92d-1d4a444749af");
    private static final List<AnimationProvider<?>> IMPERATRICE_SWORD_JAB_SET = Lists.newArrayList((Object[])new AnimationProvider[]{() -> BattleAnimations.IMPERATRICE_SWORD_JAB1, () -> BattleAnimations.IMPERATRICE_SWORD_JAB2, () -> BattleAnimations.IMPERATRICE_SWORD_JAB3});
    private static final AttackAnimationProvider DASH_ATTACK = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_DASH_ATTACK;
    private static final AttackAnimationProvider CROUCH_LIGHT = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_CROUCH_LIGHT;
    private static final AttackAnimationProvider FTILT = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_FTILT;
    private static final AttackAnimationProvider CERCLE_DE_FEU = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_CERCLE_DE_FEU;
    private static final AttackAnimationProvider RTILT = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_RTILT;
    private static final AttackAnimationProvider LTILT = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_LTILT;
    private static final AttackAnimationProvider BTILT = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_BTILT;

    public static Skill.Builder<ImperatriceAttacks> createImperatriceAttackSet() {
        return new Skill.Builder().setCategory((SkillCategory)SkillCategories.BASIC_ATTACK).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public ImperatriceAttacks(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public static void setComboCounterWithEvent(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, StaticAnimation causalAnimation, int value) {
        int prevValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.BLAZE_COMBO.get());
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        container.getExecuter().getEventListener().triggerEvents(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, (PlayerEvent)comboResetEvent);
        container.getDataManager().setData((SkillDataKey)BattleArtsDataKeys.BLAZE_COMBO.get(), (Object)comboResetEvent.getNextValue());
    }

    public static void setFtiltCombo(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, StaticAnimation causalAnimation, int value) {
        int prevValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CERCLE_DE_FEU.get());
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        container.getExecuter().getEventListener().triggerEvents(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, (PlayerEvent)comboResetEvent);
        container.getDataManager().setData((SkillDataKey)BattleArtsDataKeys.CERCLE_DE_FEU.get(), (Object)comboResetEvent.getNextValue());
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        if (executer.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(executer) == ImperatriceLumiereStyles.IMPERATRICE_SWORD) {
            return !player.m_5833_() && !executer.isAirborneState() && !AnimationHelpers.isInAir(executer) && playerState.canBasicAttack();
        }
        return !player.m_5833_() && !executer.isInAir() && playerState.canBasicAttack();
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        if (executor.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(executor) == ImperatriceLumiereStyles.IMPERATRICE_SWORD) {
            return ((Player)executor.getOriginal()).m_20096_() && executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) && (Boolean)executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false;
        }
        return super.canExecute(executor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(Integer.compare(vertic, 0));
        packet.getBuffer().writeInt(Integer.compare(horizon, 0));
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer).equals((Object)ImperatriceLumiereStyles.IMPERATRICE_SWORD) || executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer).equals((Object)ImperatriceLumiereStyles.FORIXAIM_SWORD)) {
            if (!((ServerPlayer)executer.getOriginal()).m_20096_()) {
                return;
            }
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
            }
            if (executer.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (PlayerEvent)new BasicAttackEvent(executer))) {
                return;
            }
            CapabilityItem cap = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            AttackAnimation attackMotion = null;
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            SkillContainer skillContainer = executer.getSkill((Skill)this);
            SkillDataManager dataManager = skillContainer.getDataManager();
            int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)BattleArtsDataKeys.BLAZE_COMBO.get());
            int cercleDeFeu = (Integer)dataManager.getDataValue((SkillDataKey)BattleArtsDataKeys.CERCLE_DE_FEU.get());
            if (player.m_20159_()) {
                PlayerRideableJumping ridable;
                Entity entity = player.m_20202_();
                if (entity instanceof PlayerRideableJumping && (ridable = (PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                    attackMotion = ((AnimationProvider)cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size())).get();
                    ++comboCounter;
                }
            } else {
                int fw = args.readInt();
                int sw = args.readInt();
                boolean dashAttack = player.m_20142_();
                if (dashAttack) {
                    LogUtils.getLogger().debug("Dash Attack");
                    attackMotion = DASH_ATTACK.get();
                    comboCounter = 0;
                    cercleDeFeu = 0;
                } else if (sw == -1) {
                    LogUtils.getLogger().debug("Right Tilt");
                    comboCounter = 0;
                    attackMotion = RTILT.get();
                    cercleDeFeu = 0;
                } else if (sw == 1) {
                    LogUtils.getLogger().debug("Left Tilt");
                    comboCounter = 0;
                    attackMotion = LTILT.get();
                } else if (fw == -1) {
                    LogUtils.getLogger().debug("Back Tilt");
                    attackMotion = BTILT.get();
                    comboCounter = 0;
                    cercleDeFeu = 0;
                } else if (fw == 1) {
                    executer.getSkill((Skill)this).getDataManager().setData((SkillDataKey)BattleArtsDataKeys.FTILT.get(), (Object)true);
                    LogUtils.getLogger().debug("Forward Tilt");
                    if (cercleDeFeu == 0) {
                        attackMotion = FTILT.get();
                        cercleDeFeu = 1;
                    } else if (cercleDeFeu == 1) {
                        attackMotion = CERCLE_DE_FEU.get();
                        cercleDeFeu = 0;
                    }
                    comboCounter = 0;
                } else if (player.m_6144_()) {
                    LogUtils.getLogger().debug("Down Tilt");
                    attackMotion = CROUCH_LIGHT.get();
                    comboCounter = 0;
                    cercleDeFeu = 0;
                } else {
                    executer.getSkill((Skill)this).getDataManager().setData((SkillDataKey)BattleArtsDataKeys.JAB.get(), (Object)true);
                    int comboSize = IMPERATRICE_SWORD_JAB_SET.size();
                    LogUtils.getLogger().debug("Jab");
                    LogUtils.getLogger().debug("Combo Counter: {}", (Object)(comboCounter %= comboSize));
                    attackMotion = IMPERATRICE_SWORD_JAB_SET.get(comboCounter).get();
                    ++comboCounter;
                    cercleDeFeu = 0;
                }
            }
            ImperatriceAttacks.setFtiltCombo(ComboCounterHandleEvent.Causal.TIME_EXPIRED, executer, skillContainer, attackMotion, cercleDeFeu);
            ImperatriceAttacks.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.TIME_EXPIRED, executer, skillContainer, (StaticAnimation)attackMotion, comboCounter);
            if (attackMotion != null) {
                executer.playAnimationSynchronized((StaticAnimation)attackMotion, 0.0f);
                if (executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.HEAT.get()) && ((Float)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() < 50.0f) {
                    executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.HEAT.get(), (Object)Float.valueOf(((Float)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() + 5.0f), (ServerPlayer)executer.getOriginal());
                    if (((Float)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() >= 50.0f) {
                        executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.HEAT.get(), (Object)Float.valueOf(50.0f), (ServerPlayer)executer.getOriginal());
                    }
                }
                LogUtils.getLogger().debug("Heat Level: {}", executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get()));
            }
            executer.updateEntityState();
        } else {
            super.executeOnServer(executer, args);
        }
    }
}

